import "engine" for Engine, Logger, Graphics, Mesh, Math

class Game {
  construct new() {
    _mesh = null
    _shader = null
    _time = 0.0
  }

  init() {
    _shader = Graphics.loadShader("shaders/triangle")

    // Create a grid of points with varying colors
    var vertices = []
    var spacing = 0.1
    var size = 8
    
    for (i in 0..size) {
      for (j in 0..size) {
        var x = (i / size) * 1.6 - 0.8
        var y = (j / size) * 1.6 - 0.8
        var r = i / size
        var g = j / size
        var b = 0.5
        vertices.add([x, y, 0.0, r, g, b, 1.0])
      }
    }

    _mesh = Graphics.newMesh(vertices, "points", _shader)
  }

  update(dt) {
    _time = _time + dt
    
    // Animate point colors based on time
    var vertexCount = _mesh.getVertexCount()
    for (i in 0...vertexCount) {
      var r = (Math.sin(_time + i * 0.1) + 1) * 0.5
      var g = (Math.sin(_time * 1.2 + i * 0.15) + 1) * 0.5
      var b = (Math.sin(_time * 1.5 + i * 0.2) + 1) * 0.5
      _mesh.setVertexAttribute(i, "r", r)
      _mesh.setVertexAttribute(i, "g", g)
      _mesh.setVertexAttribute(i, "b", b)
    }
  }

  draw() {
    Graphics.drawMesh(_mesh)
  }

  quit() {
    // 
  }
}
