import "engine" for Engine, Logger, Graphics, Mesh

class Game {
  construct new() {
    _lineMesh = null
    _lineStripMesh = null
    _lineLoopMesh = null
    _shader = null
    _time = 0.0
  }

  init() {
    _shader = Graphics.loadShader("shaders/triangle")

    // Line list: individual line segments
    _lineMesh = Graphics.newMesh([
      [-0.8, -0.8, 0.0, 1.0, 0.0, 0.0, 1.0],  // Start of line 1
      [-0.4, -0.8, 0.0, 1.0, 0.0, 0.0, 1.0],  // End of line 1
      [-0.8, -0.4, 0.0, 0.0, 1.0, 0.0, 1.0],  // Start of line 2
      [-0.4, -0.4, 0.0, 0.0, 1.0, 0.0, 1.0],  // End of line 2
    ], "lines", _shader)

    // Line strip: connected line segments
    _lineStripMesh = Graphics.newMesh([
      [0.0, -0.8, 0.0, 0.0, 0.0, 1.0, 1.0],
      [0.2, -0.4, 0.0, 0.0, 0.0, 1.0, 1.0],
      [0.4, -0.8, 0.0, 0.0, 0.0, 1.0, 1.0],
      [0.6, -0.4, 0.0, 0.0, 0.0, 1.0, 1.0],
      [0.8, -0.8, 0.0, 0.0, 0.0, 1.0, 1.0],
    ], "linestrip", _shader)

    // Line loop: connected line segments that close
    _lineLoopMesh = Graphics.newMesh([
      [-0.3, 0.2, 0.0, 1.0, 1.0, 0.0, 1.0],
      [ 0.3, 0.2, 0.0, 1.0, 1.0, 0.0, 1.0],
      [ 0.3, 0.6, 0.0, 1.0, 1.0, 0.0, 1.0],
      [-0.3, 0.6, 0.0, 1.0, 1.0, 0.0, 1.0],
    ], "lineloop", _shader)
  }

  update(dt) {
    _time = _time + dt
  }

  draw() {
    // Draw line list (top left)
    Graphics.drawMesh(_lineMesh)

    // Draw line strip (top right)
    Graphics.drawMesh(_lineStripMesh)

    // Draw line loop (center)
    Graphics.drawMesh(_lineLoopMesh)
  }

  quit() {
    // 
  }
}
