import "engine" for Engine, Logger, Graphics, Mesh

class Game {
  construct new() {
    _mesh = null
    _shader = null
  }

  init() {
    _shader = Graphics.loadShader("shaders/triangle")

    // Define vertices for a cube (8 vertices)
    // We'll use indexed rendering to draw 12 triangles (2 per face)
    _mesh = Graphics.newMesh([
      // Front face vertices
      [-0.5, -0.5,  0.5, 1.0, 0.0, 0.0, 1.0],  // 0: bottom-left-front
      [ 0.5, -0.5,  0.5, 0.0, 1.0, 0.0, 1.0],  // 1: bottom-right-front
      [ 0.5,  0.5,  0.5, 0.0, 0.0, 1.0, 1.0],  // 2: top-right-front
      [-0.5,  0.5,  0.5, 1.0, 1.0, 0.0, 1.0],  // 3: top-left-front
      // Back face vertices
      [-0.5, -0.5, -0.5, 1.0, 0.0, 1.0, 1.0],  // 4: bottom-left-back
      [ 0.5, -0.5, -0.5, 0.0, 1.0, 1.0, 1.0],  // 5: bottom-right-back
      [ 0.5,  0.5, -0.5, 1.0, 1.0, 1.0, 1.0],  // 6: top-right-back
      [-0.5,  0.5, -0.5, 0.5, 0.5, 0.5, 1.0],  // 7: top-left-back
    ], "triangles", _shader)

    // Set vertex map (indices) to draw a cube
    // Front face: 0, 1, 2 and 0, 2, 3
    // Back face: 5, 4, 7 and 5, 7, 6
    // Right face: 1, 5, 6 and 1, 6, 2
    // Left face: 4, 0, 3 and 4, 3, 7
    // Top face: 3, 2, 6 and 3, 6, 7
    // Bottom face: 4, 5, 1 and 4, 1, 0
    _mesh.setVertexMap([
      // Front
      0, 1, 2,  0, 2, 3,
      // Back
      5, 4, 7,  5, 7, 6,
      // Right
      1, 5, 6,  1, 6, 2,
      // Left
      4, 0, 3,  4, 3, 7,
      // Top
      3, 2, 6,  3, 6, 7,
      // Bottom
      4, 5, 1,  4, 1, 0,
    ])
  }

  update(dt) {
    // dt is seconds since last frame (double)
  }

  draw() {
    Graphics.drawMesh(_mesh)
  }

  quit() {
    // 
  }
}
