import "engine" for Engine, Logger, Graphics, Mesh, Math

class Game {
  construct new() {
    _mesh = null
    _shader = null
    _time = 0.0
    _vertexCount = 50
  }

  init() {
    _shader = Graphics.loadShader("shaders/triangle")

    // Create initial mesh with circle vertices
    var vertices = []
    for (i in 0..._vertexCount) {
      var angle = (i / _vertexCount) * 3.14159 * 2
      var x = Math.cos(angle) * 0.5
      var y = Math.sin(angle) * 0.5
      var r = (i % 3 == 0) ? 1.0 : 0.0
      var g = (i % 3 == 1) ? 1.0 : 0.0
      var b = (i % 3 == 2) ? 1.0 : 0.0
      vertices.add([x, y, 0.0, r, g, b, 1.0])
    }

    _mesh = Graphics.newMesh(vertices, "trianglestrip", _shader)
  }

  update(dt) {
    _time = _time + dt

    // Animate vertices in a wave pattern
    for (i in 0..._vertexCount) {
      var angle = (i / _vertexCount) * 3.14159 * 2
      var radius = 0.5 + Math.sin(_time * 2 + angle * 3) * 0.2
      var x = Math.cos(angle) * radius
      var y = Math.sin(angle) * radius
      
      _mesh.setVertexAttribute(i, "px", x)
      _mesh.setVertexAttribute(i, "py", y)
      
      // Animate colors
      var r = (Math.sin(_time + i * 0.1) + 1) * 0.5
      var g = (Math.sin(_time * 1.5 + i * 0.1) + 1) * 0.5
      var b = (Math.sin(_time * 2 + i * 0.1) + 1) * 0.5
      _mesh.setVertexAttribute(i, "r", r)
      _mesh.setVertexAttribute(i, "g", g)
      _mesh.setVertexAttribute(i, "b", b)
    }
    
    // Flush changes to GPU
    _mesh.flush()
  }

  draw() {
    Graphics.drawMesh(_mesh)
  }

  quit() {
    // 
  }
}
