import "engine" for Engine, Logger, Graphics, Mesh, Math

class Game {
  construct new() {
    _mesh = null
    _shader = null
    _time = 0.0
  }

  init() {
    _shader = Graphics.loadShader("shaders/triangle")

    // Create a mesh with many triangles arranged in a grid
    var vertices = []
    var gridSize = 5
    
    for (i in 0...gridSize) {
      for (j in 0...gridSize) {
        var x = (i / gridSize) * 1.6 - 0.8
        var y = (j / gridSize) * 1.6 - 0.8
        var size = 0.15
        
        // Each grid cell is a triangle
        vertices.add([x, y, 0.0, 1.0, 0.0, 0.0, 1.0])
        vertices.add([x + size, y, 0.0, 0.0, 1.0, 0.0, 1.0])
        vertices.add([x + size/2, y + size, 0.0, 0.0, 0.0, 1.0, 1.0])
      }
    }

    _mesh = Graphics.newMesh(vertices, "triangles", _shader)
  }

  update(dt) {
    _time = _time + dt
    
    // Animate draw range to reveal triangles progressively
    var totalVertices = _mesh.getVertexCount()
    var ratio = (Math.sin(_time) + 1) / 2
    var visibleCount = Math.floor(ratio * totalVertices)
    visibleCount = visibleCount - (visibleCount % 3)  // Keep multiple of 3 for triangles
    
    if (visibleCount > 0) {
      _mesh.setDrawRange(0, visibleCount)
    } else {
      _mesh.clearDrawRange()
    }
  }

  draw() {
    Graphics.drawMesh(_mesh)
  }

  quit() {
    // 
  }
}
