import "engine" for Logger, Graphics, Mesh, Math, Input, Window, Gui

class Game {
  construct new() {
    _mesh = null
    _shader = null
    _time = 0.0
  }

  init() {
    _shader = Graphics.loadShader("shaders/triangle")

    // Create a simple triangle
    _mesh = Graphics.newMesh([
      [-0.5, -0.5, 0.0, 1.0, 0.0, 0.0, 1.0],
      [ 0.5, -0.5, 0.0, 0.0, 1.0, 0.0, 1.0],
      [ 0.0,  0.5, 0.0, 0.0, 0.0, 1.0, 1.0],
    ], "triangles", _shader)
  }

  update(dt) {
    _time = _time + dt

    // Optional: draw a small GUI window (Input/Window/Gui from engine)
    var w = Window.getWidth()
    var h = Window.getHeight()
    if (Gui.beginWindow("Demo", 10, 10, 220, 100)) {
      Gui.layoutRowDynamic(22, 1)
      Gui.label("Window: %(w) x %(h)")
      if (Gui.buttonLabel("Log")) {
        Logger.info("Button pressed at %(Input.mouseX()), %(Input.mouseY())")
      }
      Gui.endWindow()
    }

    // Animate individual vertex attributes
    // Vertex 0: animate X position
    var px0 = -0.5 + Math.sin(_time) * 0.3
    _mesh.setVertexAttribute(0, "px", px0)
    
    // Vertex 0: animate red channel
    var r0 = (Math.sin(_time) + 1) * 0.5
    _mesh.setVertexAttribute(0, "r", r0)

    // Vertex 1: animate Y position
    var py1 = -0.5 + Math.cos(_time * 1.5) * 0.3
    _mesh.setVertexAttribute(1, "py", py1)
    
    // Vertex 1: animate green channel
    var g1 = (Math.cos(_time * 1.5) + 1) * 0.5
    _mesh.setVertexAttribute(1, "g", g1)

    // Vertex 2: animate Z position (depth)
    var pz2 = Math.sin(_time * 2) * 0.2
    _mesh.setVertexAttribute(2, "pz", pz2)
    
    // Vertex 2: animate blue channel
    var b2 = (Math.sin(_time * 2) + 1) * 0.5
    _mesh.setVertexAttribute(2, "b", b2)
    
    // Vertex 2: animate alpha
    var a2 = 0.5 + (Math.sin(_time * 3) + 1) * 0.25
    _mesh.setVertexAttribute(2, "a", a2)
  }

  draw() {
    Graphics.drawMesh(_mesh)
  }

  #!command(description = "Print help message")
  help() {
    Logger.info("Terminal: help - Mesh Attributes demo. Commands: help, reload.")
  }

  quit() {
    //
  }
}
