import "engine" for Gui, Logger, Window

class Game {
  construct new() {
    _quality = "Medium"
    _widthStr = "400"
    _heightStr = "300"
    _designWStr = "0"
    _designHStr = "0"
  }

  init() {
    _widthStr = "%(Window.getWidth())"
    _heightStr = "%(Window.getHeight())"
    _designWStr = "%(Window.getDesignWidth())"
    _designHStr = "%(Window.getDesignHeight())"
  }

  update(dt) {
    // Position Settings panel at bottom-left of window (y = bottom - height)
    if (Gui.beginWindow("Settings", 0, 0, 320, Window.getHeight())) {
      Gui.layoutRowDynamic(22, 1)
      Gui.label("Quality: %(_quality)")
      Gui.layoutRowDynamic(22, 3)
      if (Gui.buttonLabel("Low")) {
        _quality = "Low"
        Logger.info("Quality: Low")
      }
      if (Gui.buttonLabel("Medium")) {
        _quality = "Medium"
        Logger.info("Quality: Medium")
      }
      if (Gui.buttonLabel("High")) {
        _quality = "High"
        Logger.info("Quality: High")
      }

      Gui.layoutRowDynamic(22, 1)
      Gui.label("Fullscreen: %(Window.getFullscreen())")
      Gui.layoutRowDynamic(22, 1)
      if (Gui.buttonLabel(Window.getFullscreen() ? "Disable fullscreen" : "Enable fullscreen")) {
        Window.setFullscreen(!Window.getFullscreen())
      }

      Gui.layoutRowDynamic(22, 1)
      Gui.label("Window size (pixels)")
      Gui.layoutRowDynamic(22, 2)
      _widthStr = Gui.editString(_widthStr, 8)
      _heightStr = Gui.editString(_heightStr, 8)
      Gui.layoutRowDynamic(22, 1)
      if (Gui.buttonLabel("Apply size")) {
        applyWindowSize()
      }

      Gui.layoutRowDynamic(22, 1)
      Gui.label("Design size (viewport)")
      Gui.layoutRowDynamic(22, 2)
      _designWStr = Gui.editString(_designWStr, 8)
      _designHStr = Gui.editString(_designHStr, 8)
      Gui.layoutRowDynamic(22, 1)
      Gui.label("Scale: %(Window.getScaleMode())")
      Gui.layoutRowDynamic(22, 3)
      if (Gui.buttonLabel("stretch")) {
        Window.setScaleMode("stretch")
      }
      if (Gui.buttonLabel("letterbox")) {
        Window.setScaleMode("letterbox")
      }
      if (Gui.buttonLabel("integer")) {
        Window.setScaleMode("integer")
      }
      Gui.layoutRowDynamic(22, 1)
      if (Gui.buttonLabel("Apply design")) {
        applyDesignSize()
      }

      var dw = Window.getDesignWidth()
      var dh = Window.getDesignHeight()
      var aspectStr = (dw > 0 && dh > 0) ? "%(dw / dh)" : "-"
      Gui.layoutRowDynamic(22, 1)
      Gui.label("Aspect (design): %(aspectStr)")
      var w = Window.getWidth()
      var h = Window.getHeight()
      aspectStr = (w > 0 && h > 0) ? "%(w / h)" : "-"
      Gui.label("Aspect (window): %(aspectStr)")

      Gui.endWindow()
    }
  }

  applyWindowSize() {
    var w = Num.fromString(_widthStr)
    var h = Num.fromString(_heightStr)
    if (w > 0 && h > 0) {
      Window.setSize(w, h)
      Logger.info("Window size: %(w) x %(h)")
    }
  }

  applyDesignSize() {
    var w = Num.fromString(_designWStr)
    var h = Num.fromString(_designHStr)
    if (w >= 0 && h >= 0) {
      Window.setDesignSize(w, h, Window.getScaleMode())
    }
  }

  draw() {}
  quit() {}
}
