import "engine" for Gui, Logger, Window

class Calculator {

    construct new() {
        _display = "0"
        _pendingOp = null
        _pendingVal = 0
        _shouldClear = false
    }

    update(dt) {

        var width = Window.getWidth()
        var height = Window.getHeight()

        if (!Gui.beginWindow("Calculator", 0, 0, width, height)) {
            return
        }

        Gui.layoutRowDynamic(28, 1)
        Gui.label(_display)
        Gui.layoutRowDynamic(28, 4)
        if (Gui.buttonLabel("7")) { 
            digit(7)
        }
        if (Gui.buttonLabel("8")) { 
            digit(8)
        }
        if (Gui.buttonLabel("9")) { 
            digit(9)
        }
        if (Gui.buttonLabel("/")) { 
            applyOp("/")
        }
        if (Gui.buttonLabel("4")) { 
            digit(4)
        }
        if (Gui.buttonLabel("5")) { 
            digit(5)
        }
        if (Gui.buttonLabel("6")) { 
            digit(6)
        }
        if (Gui.buttonLabel("*")) { 
            applyOp("*")
        }
        if (Gui.buttonLabel("1")) { 
            digit(1)
        }
        if (Gui.buttonLabel("2")) { 
            digit(2)
        }
        if (Gui.buttonLabel("3")) { 
            digit(3)
        }
        if (Gui.buttonLabel("-")) { 
            applyOp("-")
        }
        if (Gui.buttonLabel("0")) { 
            digit(0)
        }
        if (Gui.buttonLabel("C")) { 
            _display = "0"
        }
        if (Gui.buttonLabel("=")) { 
            doEquals()
        }
        if (Gui.buttonLabel("+")) { 
            applyOp("+")
        }
        Gui.endWindow()
    }

    digit(n) {
        if (_display == "0" || _shouldClear) {
            _display = "%(n)"            
        } else {
            _display = _display + "%(n)"
        }

        _shouldClear = false
    }

    applyOp(op) {
        _pendingVal = Num.fromString(_display)
        _pendingOp = op
        _display = "0"
        _shouldClear = false
    }

    doEquals() {
        if (_pendingOp == null) {
            return
        }
        var a = _pendingVal
        var b = Num.fromString(_display)
        if (b == null) {
            _display = "err"
            _pendingOp = null
            _shouldClear = true
            return
        }
        if (_pendingOp == "+") {
            _display = "%(a + b)"
        } else if (_pendingOp == "-") {
            _display = "%(a - b)"
        } else if (_pendingOp == "*") {
            _display = "%(a * b)"
        } else if (_pendingOp == "/") {
            _display = b != 0 ? "%(a / b)" : "err"
        }
        _pendingOp = null
        _shouldClear = true
    }
}