#!/usr/bin/env bash

# Try to find slangc from Vulkan SDK (available since SDK 1.3.296.0)
if [ -n "$VULKAN_SDK" ] && [ -f "$VULKAN_SDK/bin/slangc" ]; then
    SLANGC="$VULKAN_SDK/bin/slangc"
elif [ -f "/usr/local/share/vulkan/sdk/bin/slangc" ]; then
    SLANGC="/usr/local/share/vulkan/sdk/bin/slangc"
elif [ -f "/opt/shader-slang-bin/bin/slangc" ]; then
    # Fallback to old installation path
    SLANGC="/opt/shader-slang-bin/bin/slangc"
elif command -v slangc >/dev/null 2>&1; then
    # Try to find slangc in PATH
    SLANGC="slangc"
else
    echo "Error: slangc not found. Please ensure:"
    echo "  1. Vulkan SDK 1.3.296.0 or later is installed and VULKAN_SDK is set, or"
    echo "  2. slangc is installed in /opt/shader-slang-bin/bin/, or"
    echo "  3. slangc is available in your PATH"
    exit 1
fi

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
mkdir -p "$SCRIPT_DIR/bin"

# Compile default shader to .spv (used by engine)
"$SLANGC" -target spirv -emit-spirv-directly -fvk-use-entrypoint-name -o "$SCRIPT_DIR/bin/default.spv" "$SCRIPT_DIR/src/default.slang"

# Also generate .h for backwards compatibility (if needed)
"$SLANGC" -target spirv -emit-spirv-directly -fvk-use-entrypoint-name -source-embed-style u32 -source-embed-name default_spv -o "$SCRIPT_DIR/bin/default.h" "$SCRIPT_DIR/src/default.slang"
