#!/usr/bin/env python3
"""Generate static.wav (noise) for the radio static effect. Run from app dir: python3 sounds/gen_static.py"""
import struct
import os
import random

def write_noise_wav(path, sample_rate=44100, duration_sec=1.0):
    n_samples = int(sample_rate * duration_sec)
    data_size = n_samples * 2
    with open(path, "wb") as f:
        f.write(b"RIFF")
        f.write(struct.pack("<I", 36 + data_size))
        f.write(b"WAVE")
        f.write(b"fmt ")
        f.write(struct.pack("<I", 16))
        f.write(struct.pack("<HH", 1, 1))
        f.write(struct.pack("<I", sample_rate))
        f.write(struct.pack("<I", sample_rate * 2))
        f.write(struct.pack("<HH", 2, 16))
        f.write(b"data")
        f.write(struct.pack("<I", data_size))
        for _ in range(n_samples):
            val = random.randint(-4000, 4000)
            f.write(struct.pack("<h", val))

if __name__ == "__main__":
    script_dir = os.path.dirname(os.path.abspath(__file__))
    write_noise_wav(os.path.join(script_dir, "static.wav"))
    print("Created static.wav in", script_dir)
