import "engine" for Audio, Input, Logger, Gui, Window

class Game {
  construct new() {
    _clickSource
    _musicSource
    _musicPlaying = false
  }

  init() {
    _clickSource = Audio.newSource("sounds/click.wav")
    _musicSource = Audio.newSource("sounds/music.wav")
    if (_clickSource == null) Logger.warn("Could not load sounds/click.wav - place a WAV file in app/sounds/")
    if (_musicSource == null) Logger.warn("Could not load sounds/music.wav - place a WAV file in app/sounds/")
  }

  update(dt) {
    if (Input.keyJustPressed("space")) {
      if (_clickSource != null) {
        Audio.play(_clickSource)
      }
    }
    if (Input.keyJustPressed("m")) {
      if (_musicSource != null) {
        if (_musicPlaying) {
          Audio.stop(_musicSource)
          _musicPlaying = false
        } else {
          _musicSource.setLooping(true)
          Audio.play(_musicSource)
          _musicPlaying = true
        }
      }
    }
    if (Gui.beginWindow("Audio Basic", 10, 10, 260, 140)) {
      Gui.layoutRowDynamic(22, 1)
      Gui.label("Space: play click")
      Gui.label("M: toggle music (loop)")
      Gui.label("Volume: %(Audio.getVolume())")
      Gui.endWindow()
    }
  }

  draw() {}
  quit() {}
}
