import "engine" for Audio, Input, Logger, Gui, Window, Math

class Game {
  construct new() {
    _clickSource
    _musicSource
    _musicPlaying = false
    _time
    _listenerX
    _sourceX
  }

  init() {
    _clickSource = Audio.newSource("sounds/click.wav")
    _musicSource = Audio.newSource("sounds/music.wav")
    if (_clickSource == null) Logger.warn("Could not load sounds/click.wav - place a WAV file in app/sounds/")
    if (_musicSource == null) Logger.warn("Could not load sounds/music.wav - place a WAV file in app/sounds/")
  
    _time = 0
    _listenerX = 0
    _sourceX = 5
  }

  update(dt) {
    _time = _time + dt
    if (Input.key("a")) _listenerX = _listenerX - 3 * dt
    if (Input.key("d")) _listenerX = _listenerX + 3 * dt
    Audio.setPosition(_listenerX, 0, 0)
    Audio.setOrientation(1, 0, 0, 0, 1, 0)

    _sourceX = 5 + 3 * Math.sin(_time)
    if (_clickSource != null) {
      _clickSource.setPosition(_sourceX, 0, 0)
      if (Input.keyJustPressed("space")) Audio.play(_clickSource)
    }

    if (_musicSource != null) {
      _musicSource.setPosition(_sourceX, 0, 0)
      if (Input.keyJustPressed("m")) Audio.play(_musicSource)
    }

    if (Input.keyJustPressed("m")) {
      if (_musicSource != null) {
        if (_musicPlaying) {
          Audio.stop(_musicSource)
          _musicPlaying = false
        } else {
          _musicSource.setLooping(true)
          Audio.play(_musicSource)
          _musicPlaying = true
        }
      }
    }

    if (Gui.beginWindow("Audio 3D", 10, 10, 280, 120)) {
      Gui.layoutRowDynamic(22, 1)
      Gui.label("A/D: move listener (x)")
      Gui.label("Space: play source")
      Gui.label("Listener x: %(_listenerX)")
      Gui.label("Source moves on sine path")
      Gui.endWindow()
    }
  }

  draw() {}
  quit() {}
}
