# Plume3D — macOS apps archive

This archive contains the **Plume3D** macOS executable and a set of example apps. Run any app with:

```bash
./plume3d <app_directory>
```

Or use the launch scripts (see below).

## Contents

- **plume3d** — Plume3D engine executable (macOS)
- **Example apps** — One folder per app; each has a `game.toml` and `main.wren` (and any assets)

## Running an app

From this directory:

```bash
./plume3d aspect_ratio_demo
./plume3d plume_triangle
```

You can also pass an absolute path to an app folder:

```bash
./plume3d /path/to/my_game
```

## Launch scripts

Each app has a shell script you can run to start it (no need to type the app name). Run from anywhere:

| Script | App |
|--------|-----|
| `./run_aspect_ratio_demo.sh` | Aspect Ratio Demo — design resolution and letterbox scaling |
| `./run_audio_3d.sh` | Audio 3D — 3D listener and moving sound source |
| `./run_audio_basic.sh` | Audio Basic — play sounds and toggle looping music |
| `./run_audio_player.sh` | Audio Player — radio-style tuner with static |
| `./run_audio_player_3d.sh` | Audio Player 3D — 3D radio with power/knobs/body rotate |
| `./run_blend_load.sh` | Blend Load — load Cube.blend, FPS camera, raycast-drag cube |
| `./run_gui_calculator.sh` | GUI Calculator — full calculator with Nuklear GUI |
| `./run_gui_configurator.sh` | GUI Configurator — window/settings panel (size, scale mode) |
| `./run_gui_input.sh` | GUI Input — live mouse/key/modifier display |
| `./run_gui_overview.sh` | GUI Overview — basic windows, labels, buttons |
| `./run_gui_terminal.sh` | GUI Terminal — in-game terminal and `#!command` |
| `./run_mesh_attributes.sh` | Mesh Attributes — animate vertex position/color, GUI |
| `./run_mesh_draw_range.sh` | Mesh Draw Range — animate draw range to reveal triangles |
| `./run_mesh_dynamic.sh` | Mesh Dynamic — animated trianglestrip circle |
| `./run_mesh_indexed.sh` | Mesh Indexed — indexed cube (8 vertices, vertex map) |
| `./run_mesh_lines.sh` | Mesh Lines — line list, strip, loop |
| `./run_mesh_points.sh` | Mesh Points — point grid with animated colors |
| `./run_plume_triangle.sh` | Plume Triangle — minimal triangle (shader + mesh) |
| `./run_window_demo.sh` | Window Demo — window title, width, height |

Example:

```bash
./run_plume_triangle.sh
```

Scripts change into this directory automatically, so you can run them from any folder. If you get **Permission denied**, make them executable once:

```bash
chmod +x run_*.sh
```

## App list (for `./plume3d <dir>`)

| Directory | Description |
|-----------|-------------|
| `aspect_ratio_demo` | Design resolution (1280×720) and letterbox scaling |
| `audio_3d` | 3D audio: move listener (A/D), source on sine path, Space to play |
| `audio_basic` | Space = click, M = toggle looping music |
| `audio_player` | Tune with Left/Right; stations from channels.toml, static when off-frequency |
| `Audio_Player_3d` | 3D radio: power button, knobs, body rotate; blend-loaded model |
| `blend_load` | Load Cube.blend, instantiate camera/light/cube; drag cube with mouse |
| `gui_calculator` | Calculator built with GUI buttons |
| `gui_configurator` | Quality, fullscreen, window size, design size, scale mode |
| `gui_input` | Live mouse, keys, modifiers, window size |
| `gui_overview` | Two windows, labels, buttons |
| `gui_terminal` | Backtick = terminal; commands: help, hello, reload |
| `mesh_attributes` | Animate triangle vertices; GUI and terminal |
| `mesh_draw_range` | Reveal grid of triangles over time |
| `mesh_dynamic` | Animated circle (trianglestrip, setVertexAttribute + flush) |
| `mesh_indexed` | Cube with 8 vertices and vertex map |
| `mesh_lines` | Line list, line strip, line loop |
| `mesh_points` | Point grid with animated colors |
| `plume_triangle` | Minimal: shader + colored triangle |
| `window_demo` | Display window title and size |

## Audio attributions

Some example apps use music from [OpenGameArt.org](https://opengameart.org). Credits:

- [Crystal Cave Song](https://opengameart.org/content/crystal-cave-song18)
- [Town Theme RPG](https://opengameart.org/content/town-theme-rpg)
- [The Field of Dreams](https://opengameart.org/content/the-field-of-dreams)
- [Caketown (Cute/Playful)](https://opengameart.org/content/caketown-cuteplayful)

## Requirements

- **macOS** (this archive is built for macOS).
- A display and supported GPU/drivers for Vulkan.

For other platforms or building from source, see the [Plume3D repository](https://github.com/WyldMagic/Plume3d).
